# https://fedoraproject.org/wiki/Packaging:Haskell

%global pkg_name unix-handle

Name:           ghc-%{pkg_name}
Version:        0.0.0
Release:        0.%{scriptsversion}%{?dist}
Summary:        POSIX operations on Handles

License:        BSD
URL:            http://hackage.haskell.org/package/%{pkg_name}
Source0:        http://hackage.haskell.org/packages/archive/%{pkg_name}/%{version}/%{pkg_name}-%{version}.tar.gz

BuildRequires:  ghc-Cabal-devel
BuildRequires:  ghc-rpm-macros %{!?without_hscolour:hscolour}
# Begin cabal-rpm deps:
BuildRequires:  ghc-unix-devel
# End cabal-rpm deps

%description
This package provides versions of functions from "System.Posix.Files" that
operate on 'System.IO.Handle' instead of 'System.IO.FilePath' or
'System.Posix.Fd'. This is useful to prevent race conditions that may arise
from looking up the same path twice.


%package devel
Summary:        Haskell %{pkg_name} library development files
Provides:       %{name}-static = %{version}-%{release}
Requires:       ghc-compiler = %{ghc_version}
Requires(post): ghc-compiler = %{ghc_version}
Requires(postun): ghc-compiler = %{ghc_version}
Requires:       %{name}%{?_isa} = %{version}-%{release}

%description devel
This package provides the Haskell %{pkg_name} library development files.


%prep
%setup -q -n %{pkg_name}-%{version}


%build
%ghc_lib_build


%install
%ghc_lib_install


%post devel
%ghc_pkg_recache


%postun devel
%ghc_pkg_recache


%files -f %{name}.files
%doc LICENSE


%files devel -f %{name}-devel.files


%changelog
* Mon May 26 2014 Alex Chernyakhovsky <achernya@mit.edu> - 0.0.0-0
- Updated packaging for F20 with cabal-rpm

* Fri May 25 2012 Anders Kaseorg <andersk@mit.edu> - 0.0.0-0
- regenerated packaging with cabal2spec-0.25.5

* Mon May  2 2011 Alexander Chernyakhovsky <achernya@mit.edu> - 0.0.0-0
- regenerated packaging with cabal2spec-0.22.5

* Thu Sep  9 2010 Anders Kaseorg <andersk@mit.edu> - 0.0.0-0
- initial packaging for Fedora automatically generated by cabal2spec-0.22.1
